/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpEngine.BasicScheduler;
import ibm.nways.analysis.dpEngine.Daily;
import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.DpNode;
import ibm.nways.analysis.dpEngine.DpPollingDefinition;
import ibm.nways.analysis.dpEngine.MismatchRowNode;
import ibm.nways.analysis.dpEngine.NodeAndCount;
import ibm.nways.analysis.dpEngine.NodeList;
import ibm.nways.analysis.dpEngine.OiList;
import ibm.nways.analysis.dpEngine.Scheduled;
import ibm.nways.analysis.dpEngine.Weekly;
import ibm.nways.jdm.snmp.PollingAction;
import ibm.nways.jdm.snmp.PollingFilter;
import ibm.nways.jdm.snmp.PollingInterval;
import ibm.nways.jdm.snmp.PollingPreFilter;
import ibm.nways.jdm.snmp.SnmpPoller;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SnmpSessionFactory;
import ibm.nways.jdm.snmp.TableHandler;
import ibm.nways.jdm.snmp.TablePoller;
import ibm.nways.jdm.snmp.TablePollingAction;
import ibm.nways.jdm.snmp.TablePollingFilter;
import ibm.nways.jdm.snmp.TablePollingPreFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DpPollingInstance
implements Scheduled {
    private DpPollingDefinition pollingDef;
    private String hostname;
    private NodeAndCount session;
    private Vector nodes;
    private BasicScheduler scheduler;
    private Object schedule;
    private boolean sendEvents = true;
    private int offAction = 0;

    protected DpPollingInstance(DpPollingDefinition dpPollingDefinition, String string, String string2, NodeList nodeList, Hashtable hashtable, boolean bl) throws Exception {
        this.pollingDef = dpPollingDefinition;
        this.hostname = string;
        this.session = nodeList.findNode(string, string2, bl);
        if (this.session == null) {
            try {
                SnmpSession snmpSession = SnmpSessionFactory.makeSession((String)string, (int)-1, (String)string2, null);
                if (bl) {
                    snmpSession.cancelRedShift();
                }
                this.session = nodeList.addNode(string, snmpSession, string2, bl);
            }
            catch (Exception exception) {
                DpInterfaceImpl.LogMessage("could not open session to " + string + " Exception:" + exception);
                DpInterfaceImpl.LogMessage(" CommName:" + string2);
                throw exception;
            }
        }
        this.nodes = new Vector();
    }

    protected DpPollingInstance(DpPollingDefinition dpPollingDefinition, String string, String string2, String string3, NodeList nodeList, boolean bl) throws Exception {
        this.pollingDef = dpPollingDefinition;
        this.hostname = string;
        this.session = nodeList.findNode(string, string2, bl);
        if (this.session == null) {
            try {
                SnmpSession snmpSession = SnmpSessionFactory.makeSession((String)string, (int)-1, (String)string2, (String)string3);
                if (bl) {
                    snmpSession.cancelRedShift();
                }
                this.session = nodeList.addNode(string, snmpSession, string2, bl);
            }
            catch (Exception exception) {
                DpInterfaceImpl.LogMessage("could not open session to " + string + " Exception:" + exception);
                DpInterfaceImpl.LogMessage("def=" + dpPollingDefinition.toString() + " getCommName:" + string2 + " setComName:" + string3);
                throw exception;
            }
        }
        this.nodes = new Vector();
    }

    protected boolean addNode(long l, NotifyObject notifyObject, Hashtable hashtable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = true;
        int n = this.nodes.size();
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("  POI: -->Adding Node ");
        }
        if (this.session == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (l == ((DpNode)this.nodes.elementAt(n2)).getId()) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        if (!bl2) {
            DpNode dpNode = OiList.containsRelativeIndex(this.getPollingDefinition().getPollingObjectDefinition().getExpression()) ? new MismatchRowNode(this, l, bl) : new DpNode(this, l, bl);
            if (dpNode != null) {
                bl3 = dpNode.initialize(this, null, null, this.session.getSession(), hashtable, notifyObject, null);
                if (bl3) {
                    this.session.addUse();
                    this.nodes.addElement(dpNode);
                } else {
                    DpInterfaceImpl.LogMessage("DpPollingInstance:node did not initialize for : " + this.hostname);
                }
            } else {
                bl3 = false;
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage("  POI: -->Adding node -- null DpNode");
                }
            }
        } else if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("  POI: -->Adding node -- already present ");
        }
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("  POI: -->Adding node -- returning : " + bl3);
        }
        return bl3;
    }

    protected boolean changeNotifyObjects(NotifyObject notifyObject) {
        boolean bl = true;
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            DpNode dpNode = (DpNode)this.nodes.elementAt(n2);
            boolean bl2 = dpNode.changeNotifyObject(notifyObject);
            if (!bl2) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    protected boolean addNotifyObject(long l, NotifyObject notifyObject, SnmpPoller snmpPoller, TablePoller tablePoller, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = true;
        int n = this.nodes.size();
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("  POI: -->Adding NO ");
        }
        if (this.session == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (l == ((DpNode)this.nodes.elementAt(n2)).getId()) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        if (!bl2) {
            DpNode dpNode = OiList.containsRelativeIndex(this.getPollingDefinition().getPollingObjectDefinition().getExpression()) ? new MismatchRowNode(this, l, bl) : new DpNode(this, l, bl);
            if (dpNode != null) {
                bl3 = dpNode.initialize(this, snmpPoller, tablePoller, this.session.getSession(), null, notifyObject, null);
                if (bl3) {
                    this.session.addUse();
                    this.nodes.addElement(dpNode);
                } else {
                    DpInterfaceImpl.LogMessage("node did not initialize for : " + this.hostname);
                }
            } else {
                bl3 = false;
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage("  POI: -->Adding NO -- null DpNode");
                }
            }
        } else if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("  POI: -->Adding NO -- already present ");
        }
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("  POI: -->Adding NO -- returning : " + bl3);
        }
        return bl3;
    }

    protected boolean addNotifyObject(long l, NotifyObject notifyObject, boolean bl) {
        OiList oiList = this.pollingDef.getOiList();
        if (oiList == null) {
            DpInterfaceImpl.LogMessage("DpPollingInstance: handle adding NO to instance of def with inserts!!!!");
            return false;
        }
        SnmpPoller snmpPoller = null;
        TablePoller tablePoller = null;
        DpInterfaceImpl.modifyHeartbeatTimeout(notifyObject.getPollingInterval() * 1000);
        if (oiList.getScalarOIcount() != 0) {
            snmpPoller = new SnmpPoller(new PollingInterval(notifyObject.getPollingInterval() * 1000), oiList.getScalarOIs(), true, (PollingAction)this.pollingDef, (PollingFilter)this.pollingDef, (PollingPreFilter)this.pollingDef);
        }
        if (oiList.getWildcardOIcount() != 0) {
            tablePoller = new TablePoller(new PollingInterval(notifyObject.getPollingInterval() * 1000), oiList.getWildcardOIs(), null, true, (TableHandler)this.pollingDef, (TablePollingAction)this.pollingDef, (TablePollingFilter)this.pollingDef, (TablePollingPreFilter)this.pollingDef);
        }
        DpInterfaceImpl.LogMessage("new poller interval is : " + snmpPoller.getInterval().interval);
        return this.addNotifyObject(l, notifyObject, snmpPoller, tablePoller, bl);
    }

    protected boolean removeNotifyObject(long l, NotifyObject notifyObject) {
        boolean bl = true;
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            if (l == ((DpNode)this.nodes.elementAt(n2)).getId()) {
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage("found node to remove from the POI");
                }
                ((DpNode)this.nodes.elementAt(n2)).stopPolling();
                this.nodes.removeElementAt(n2);
                break;
            }
            ++n2;
        }
        return bl;
    }

    protected boolean removeSpecificNode(long l) {
        boolean bl = false;
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            DpNode dpNode = (DpNode)this.nodes.elementAt(n2);
            if (dpNode.getId() == l) {
                dpNode.stopPolling();
                this.nodes.removeElementAt(n2);
                return true;
            }
            ++n2;
        }
        return bl;
    }

    protected boolean removeAllNodes() {
        boolean bl = true;
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            ((DpNode)this.nodes.elementAt(n2)).stopPolling();
            ++n2;
        }
        this.nodes.removeAllElements();
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("removeAllNotifyObjects()");
        }
        return bl;
    }

    protected boolean scheduleInstance(Daily daily, int n) {
        if (this.scheduler != null) {
            this.scheduler.terminate();
            this.scheduler = null;
        }
        this.schedule = null;
        if (daily != null) {
            this.scheduler = new BasicScheduler(1, this);
            this.schedule = daily;
            this.scheduler.start();
            daily.activateSchedule(this.scheduler);
            this.offAction = n;
        }
        return true;
    }

    protected boolean scheduleInstance(Weekly weekly, int n) {
        if (this.scheduler != null) {
            this.scheduler.terminate();
            this.scheduler = null;
        }
        this.schedule = null;
        if (weekly != null) {
            this.scheduler = new BasicScheduler(2, this);
            this.schedule = weekly;
            this.scheduler.start();
            weekly.activateSchedule(this.scheduler);
            this.offAction = n;
        }
        return true;
    }

    protected void changeState(String string) {
        if (DpInterfaceImpl.trace_schedule) {
            DpInterfaceImpl.LogMessage("POI: changeState(" + string.toString() + ")");
        }
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            ((DpNode)this.nodes.elementAt(n2)).changeState(string);
            ++n2;
        }
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("changeState for POI");
        }
    }

    protected void listNodes(Vector vector) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            DpNode dpNode = (DpNode)enumeration.nextElement();
            vector.addElement(dpNode);
        }
    }

    protected void activatePollers() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            DpNode dpNode = (DpNode)enumeration.nextElement();
            if (dpNode.isPolling()) continue;
            dpNode.startPolling();
        }
    }

    protected void suspendPollers() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            DpNode dpNode = (DpNode)enumeration.nextElement();
            if (!dpNode.isPolling()) continue;
            dpNode.suspendPolling();
        }
    }

    protected void changeHistorySize(int n) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            DpNode dpNode = (DpNode)enumeration.nextElement();
            dpNode.changeHistorySize(n);
        }
    }

    protected DpNode getSpecificNode(long l) {
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            DpNode dpNode = (DpNode)this.nodes.elementAt(n2);
            if (dpNode.getId() == l) {
                return dpNode;
            }
            ++n2;
        }
        return null;
    }

    protected Vector getHistory(long l, Vector vector, long l2) {
        Vector vector2 = this.getHistory(l, l2);
        if (vector2 != null && vector != null) {
            int n = vector.size();
            Vector vector3 = new Vector();
            int n2 = vector2.size();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    if (((String)vector.elementAt(n4)).equals(((DataPoint)vector2.elementAt(n3)).getID())) {
                        vector3.addElement(vector2.elementAt(n3));
                    }
                    ++n4;
                }
                ++n3;
            }
            vector2 = vector3;
        }
        return vector2;
    }

    protected Vector getHistory(long l, long l2) {
        if (this.nodes.size() == 1) {
            return ((DpNode)this.nodes.elementAt(0)).getHistory(l2);
        }
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            DpNode dpNode = (DpNode)this.nodes.elementAt(n2);
            if (dpNode.getId() == l) {
                return dpNode.getHistory(l2);
            }
            ++n2;
        }
        return null;
    }

    protected Vector getRowIds(long l) {
        if (this.nodes.size() == 1) {
            return ((DpNode)this.nodes.elementAt(0)).getRowIds();
        }
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            DpNode dpNode = (DpNode)this.nodes.elementAt(n2);
            if (l == dpNode.getId()) {
                return dpNode.getRowIds();
            }
            ++n2;
        }
        return null;
    }

    protected boolean clearHistory(long l, long l2) {
        boolean bl = false;
        if (this.nodes.size() == 1) {
            ((DpNode)this.nodes.elementAt(0)).clearHistory(l2);
            bl = true;
        } else {
            int n = this.nodes.size();
            int n2 = 0;
            while (n2 < n) {
                DpNode dpNode = (DpNode)this.nodes.elementAt(n2);
                if (dpNode.getId() == l) {
                    dpNode.clearHistory(l2);
                    bl = true;
                }
                ++n2;
            }
        }
        return bl;
    }

    protected void setAutoThresholdLevel(NotifyObject notifyObject, float f) {
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            if (notifyObject.equals((DpNode)this.nodes.elementAt(n2))) {
                ((DpNode)this.nodes.elementAt(n2)).setAutoThresholdLevel(f);
                return;
            }
            ++n2;
        }
    }

    public void changeInterval(Object object) {
        if (this.offAction == 1) {
            this.sendEvents = (Boolean)object;
            return;
        }
        if (this.offAction == 3) {
            this.changeState((String)object);
            return;
        }
        if (((Boolean)object).booleanValue()) {
            this.activatePollers();
            return;
        }
        this.suspendPollers();
    }

    public void intervalStarted(Object object) {
        this.changeInterval(object);
    }

    public void intervalEnded(Object object) {
    }

    protected boolean idExists(long l) {
        boolean bl = false;
        int n = this.nodes.size();
        int n2 = 0;
        while (n2 < n) {
            if (((DpNode)this.nodes.elementAt(n2)).getId() == l) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    protected boolean hasNodes() {
        return this.nodes.size() != 0;
    }

    protected boolean sendEvents() {
        return this.sendEvents;
    }

    protected String getHostname() {
        return this.hostname;
    }

    protected DpPollingDefinition getPollingDefinition() {
        return this.pollingDef;
    }

    protected NodeAndCount getSession() {
        return this.session;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("   hostname : ");
        stringBuffer.append(this.hostname);
        stringBuffer.append("\n   nodes : \n   {");
        int n = 0;
        while (n < this.nodes.size()) {
            stringBuffer.append((DpNode)this.nodes.elementAt(n)).toString();
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("   }");
        return stringBuffer.toString();
    }
}

